\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{reports} [2001/02/10 v2.0 v4.0 Classe Reports]
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions
\PassOptionsToClass{leqno,a4paper}{article}
\LoadClass{article}
%
% Mides noves per a aprofitar el paper
\setlength{\hoffset}{-16mm}
\setlength{\textwidth}{145mm}
\setlength{\parskip}{1ex}
\def\mathrev{\setlength\paperheight{11in} \setlength\paperwidth{8.5in}
            \setlength\textheight{145mm}
            \setlength\voffset{40mm} \setlength{\hoffset}{-12mm}
            \def\thepage{}}
%
\RequirePackage{alseda}
%
%
% ************
% * Comandes *
% ************
%
% Generals
%
\newcommand{\titol}[1]{\vspace*{1cm}\begin{center}{
  \Large\bfseries #1}\end{center}\par\par\bigskip\bigskip\par\par}
\newcommand{\reporttitol}[2]{\titol{Report on the paper \emph{#1} by #2}}
\newcommand{\reportpartitol}[2]{\titol{Report on the paper\\ \emph{#1} \\ by\\[3mm] #2}}

\newenvironment{remarks}[1][Remarks]{%
   \ifx#1\empty\else\section*{#1}\fi\description}{\enddescription}
%
\def\@page@num@curr{1}
\def\@base@rem#1#2{\edef\@page@num@curr{#1}%
     \item[\textup{Page #1#2:\ }]%
}
\newcommand{\remnoline}[1][\@page@num@curr]{\@base@rem{#1}{\empty}}
\newcommand{\freerem}[2][\@page@num@curr]{\@base@rem{#1}{; #2}}
\newcommand{\rem}[2][\@page@num@curr]{%
    \@base@rem{#1}{\ifx\empty#2\else, Line #2\fi}%
}
\newcommand{\remitem}[1][\empty]{%
   \ifx\empty#1 \item[$\bullet$] \else \item[\textup{#1:\ }]\fi%
}
%
\newcommand{\change}[2]{``#1''\ $\longrightarrow$\ ``#2''}
\newcommand{\remchan}[4][\@page@num@curr]{\@base@rem{#1}{, Line #2}\change{#3}{#4}}
%
\newenvironment{proclaim}[1]{
  \trivlist \item[\hskip\labelsep{\bfseries #1.}]\itshape\ }{\endtrivlist}
%
% For compatibility
\let\proclama\proclaim \let\endproclama\endproclaim
\endinput
