\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{alseda} [2001/02/10 v2.0 Classe del Lluis Alseda]
\newcommand\@ptsize{11pt}
\DeclareOption{10pt}{\renewcommand\@ptsize{10pt}}
\DeclareOption{11pt}{\renewcommand\@ptsize{11pt}}
\DeclareOption{12pt}{\renewcommand\@ptsize{12pt}}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions
\PassOptionsToClass{\@ptsize,a4paper}{article}
\let\@ptsize\relax
\LoadClass{article}
%
\setlength{\hoffset}{-1in}
\setlength{\voffset}{-12mm}
\setlength{\textheight}{220mm}
\setlength{\textwidth}{155mm}
\setlength{\parskip}{1mm}
%
% Comandes d'abstract, Capsalera i adreces
%
\newcommand{\address}[2][]{%
  \ifx\@add@ress\@undefined\gdef\@add@ress{\par\par\bigskip}\AtEndDocument{\@add@ress}\fi%
  \g@addto@macro\@add@ress{\bigskip\noindent{\small\scshape%
      \ifx#1\empty\else{\bfseries Address of #1:}\ \fi#2}\par\par}}
\newcommand{\email}[1]{\par\par\noindent{\normalfont{\itshape E-mail:\/} \texttt{#1}}\par\par}
%
\renewenvironment{abstract}{\small\quotation\noindent
  {\bfseries \abstractname}}{\endquotation \par}
%
\newcommand{\footnotetextplain}[1]{\begingroup\def\@thefnmark{}%
  \long\def\@makefntext##1{\parindent 0pt\noindent ##1}\@footnotetext{#1}
  \endgroup}
%
\newcommand{\AMSsubjclass}[1]{\footnotetextplain{2000
   \emph{Mathematics Subject Classification:} Primary #1.}}
\newcommand{\keywords}[1]{\footnotetextplain{\emph{Key words and phrases:} #1.}}
%
\newenvironment{acknowledgements}{%
  \trivlist \item[\hskip\labelsep{\bfseries Acknowledgements. }]}{
  \endtrivlist}
%
% Comandes generals
%
\RequirePackage{alseda,alsedathm}
\endinput
%
% Comandes no usuals; fora de circulacio
%
% \author ara s acumulatiu.
% \address afegeix el parametre a \@address i escriu \@address a final de fitxer
% La comanda \AuthorAndAddress Funciona de la segent manera (recordem que els parametres
% entre [] sn opcionals):
% \AuthorAndAddress[[separador]nom_de_l'autor]{adrea_de_l'autor}
% <separador>: s'inserta ABANS de nom_de_l'autor a la llista d'autors. El defecte s
% ", ". Es equivalent a \author{separador} (de fet a \author{<separador><nom_de_l'autor>}).
% nom_de_l'autor: S'afegeix a la llista d'autors (\author{nom_de_l'autor}). Si es no buit
% l'adrea s:
%     Address of nom_de_l'autor: adrea_de_l'autor.
%
\def\author#1{\author@alse{#1}}
\def\address#1{\begingroup\def\@dummy@{#1}%
    \ifx\@dummy@\empty\ClassError{Alseda}{%
      Address cannot be empty in \string\address}{}
    \else\ifx\@address\@undefined\gdef\@address{\par\par\bigskip}\AtEndDocument{\@address}\fi%
    \g@addto@macro\@address{\bigskip\noindent{\small\scshape #1}\par\par}\fi\endgroup}
\def\author@alse#1{\gdef\@author{#1}\gdef\author##1{\g@addto@macro\@author{##1}}%
                   \global\let\author@alse\add@to@author@alse}
\newcommand{\add@to@author@alse}[2][, ]{\g@addto@macro\@author{#1#2}}
\def\AuthorAndAddress{\@ifnextchar [{\@AuthorAndAddress@i}{\address}}
\def\@AuthorAndAddress@i#1{\@ifnextchar [{\@AuthorAndAddress@iip[}{\@AuthorAndAddress@ip[}}
\def\@AuthorAndAddress@ip[#1]#2{\author@alse{#1}\address{Address of #1: #2}}
\def\@AuthorAndAddress@iip[[#1]#2]#3{\author@alse[#1]{#2}\address{Address of #2: #3}}
