\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{congres} [2003/07/10 v4.0 Classe Congres]
\DeclareOption{dvips}{\PassOptionsToPackage{dvips}{color}}
\DeclareOption{pdftex}{\PassOptionsToPackage{pdftex}{color}}
\def\@foot@size{\tiny}
\def\@default@size{\small}
\def\@heads@size{\normalsize}
\def\@slide@title@size{\large}
\def\@main@title@size{\LARGE}
\DeclareOption{largefont}{
    \def\@foot@size{\footnotesize}
    \def\@default@size{\large}
    \def\@heads@size{\Large}
    \def\@slide@title@size{\LARGE}
    \def\@main@title@size{\Huge}
}
\newif\if@fonsblanc \@fonsblancfalse
\DeclareOption{fonsblanc}{\@fonsblanctrue}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{slides}}
\ProcessOptions
\LoadClass[a4paper]{slides}
\let\thispagestyle\pagestyle
%
% manipulacio de \list i \endlist per a implementar itemitzacio automtica
%
\newif\if@itemizedslide \@itemizedslidefalse
% El que segueix es el \list original del latex.ltx amb \@itemizedslidetrue
\def\list#1#2{%
  \ifnum \@listdepth >5\relax
    \@toodeep
  \else
    \global\advance\@listdepth\@ne
  \fi
  \rightmargin\z@
  \listparindent\z@
  \itemindent\z@
  \csname @list\romannumeral\the\@listdepth\endcsname
  \def\@itemlabel{#1}%
  \let\makelabel\@mklab
  \@nmbrlistfalse \@itemizedslidetrue
  #2\relax
  \@trivlist
  \parskip\parsep
  \parindent\listparindent
  \advance\linewidth -\rightmargin
  \advance\linewidth -\leftmargin
  \advance\@totalleftmargin \leftmargin
  \parshape \@ne \@totalleftmargin \linewidth
  \ignorespaces}
%
\g@addto@macro{\endlist}{\@itemizedslidefalse}
%
\newcommand{\labeledlist}[2][\bf\colorditem]{%
    \list{#2}{\def\makelabel##1{{#1 ##1}\hfill}%\setlength\labelsep{1em}
                \rightmargin\z@\itemindent\z@\leftmargin \labelsep
                \setbox\z@\hbox{\makelabel{#2}}\labelwidth\wd\z@\advance\leftmargin by \labelwidth
    }
}
\def\endlabeledlist{\par\par\endlist}
\def\compactlist{\itemsep=0pt\parsep=0pt\topsep=3pt plus 1pt minus 1 pt}
%
% Complements i mani pulacions de  l'estil
%
% Slides
%
\newif\if@slide@on \@slide@onfalse
\g@addto@macro{\slide}{\@slide@ontrue}
\def\enddefaultslide{\if@itemizedslide\endlist\fi\par\par\break\@slide@onfalse}
\def\endslide{\if@itemizedslide\endlist\fi\par\par\vfill\par\par\break\@slide@onfalse}
\let\endoverlay\endslide
%
\newcommand{\newslide}[1][]{%
   \if@slide@on\end{slide}\fi \begin{slide}
   \ifx#1\empty\else\Titol{#1}\fi
}
%
% Comandes utilitaries afegides a l'estil
%
\newcommand{\Titol}[2][\@slide@title@size]{%
  \baselineskip1.7\baselineskip\par\par{\colordetitol\bf #1 #2}
  \par\par\baselineskip\normalbaselineskip\bigskip\par\par}
%
\newcommand{\TitolSlide}[1]{\if@slide@on\end{slide}\fi \begin{slide}\strut\par\par\vfill
   \begin{center}\Titol[\@main@title@size]{#1}\end{center}
   \vfill\par\par}
\newcommand{\TitolPrincipal}[3][by]{% Per si s'utiliza babel; que "descuajeringa" els itemize
    \def\labelitemi{\textbullet}\def\labelitemii{\normalfont\bfseries \textendash}%
    \def\labelitemiii{\textasteriskcentered}\def\labelitemiv{\textperiodcentered}%
    \slide\strut\par\par\vspace{2ex}\begin{center}\large % Aqui ja anem per feina
    \Titol[\@main@title@size]{#2} \par\par #1 \par\par #3 \end{center}\vfill\endslide}
%
\newcounter{slide@ctual}
\newcommand{\peudepagina}[2]{\def\ps@slide{\def\@oddhead{}%
 \def\@evenhead{}
 \def\@evenfoot{{\@foot@size \textsf{#1} \hfill \theslide%
    \ifnum\c@slide@ctual=\c@slide%
          \ifnum\c@overlay=0\stepcounter{overlay}\fi%
          \stepcounter{overlay}-\roman{overlay}%
    \fi \setcounter{slide@ctual}{\value{slide}}%
    \ifx{#2}\empty\else /#2\fi}%
} \let\@oddfoot\@evenfoot
}} \setlength{\footskip}{2em}
%

\newcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {2.25ex \@plus1ex \@minus.2ex}%
                                    {-1em}%
                                    {\normalfont\Large\bfseries\colorditem}}
%
% I nicialitzaci del document
%
\AtBeginDocument{\@default@size}
\AtEndDocument{\if@slide@on\end{slide}\fi }
\ifx\CongresLocalOptions\@undefined\else\CongresLocalOptions\fi
\special{papersize=\the\paperwidth,\the\paperheight}
%
% Color
%
\RequirePackage{color}
\def\@color@command#1{%
  \expandafter\gdef\csname #1\endcsname{\color{#1}}%
  \expandafter\gdef\csname text#1\endcsname##1{\textcolor{#1}{##1}}%
}
\@color@command{black}
\@color@command{white}
\@color@command{red}
\@color@command{green}
\@color@command{blue}
\@color@command{cyan}
\@color@command{magenta}
\@color@command{yellow}
%
\def\@copia@color#1>#2{%
       \expandafter\def\csname\string\color @#2\endcsname{\csname\string\color @#1\endcsname}%
       \@color@command{#2}
}
%
\newcommand{\newrgbcolor}[2]{\definecolor{#1}{rgb}{#2}\@color@command{#1}}
%
% Eleccio de colors
%
\@copia@color{white}>{colordefons}
\if@fonsblanc\else
      \definecolor{colordefons}{cmyk}{0,0,0.3,0} \@color@command{colordefons}
      \pagecolor{colordefons}
\fi
%
\@copia@color{blue}>{colordetitol}
\@copia@color{red}>{coloremph}
\newrgbcolor{orchid}{0.854902,0.439216,0.839216}
\@copia@color{orchid}>{colorproclaim}
\newrgbcolor{colorditem}{0.490196,0.14902,0.803922} % purple3
\newcommand{\ItemEstandarNoLine}[2]{\textcolorditem{#1:} #2}
\newcommand{\ItemEstandar}[2]{\textcolorditem{#1:} #2\newline}
%
% Comandes Utilitaries
%
%
\newcommand{\cemph}[1]{\emph{\coloremph #1}}
\newcommand{\ctextbf}[1]{\textbf{\coloremph #1}}
%
\newenvironment{proclaim}[1]{\normalfont\trivlist%
  \item[]\noindent{\@heads@size\bf\colorproclaim  #1.}\ \itshape\ignorespaces}{\endtrivlist}
\newenvironment{explain}[1]{\normalfont\trivlist%
  \item[]\noindent{\@heads@size\bf\colorproclaim  #1}\ \ignorespaces}{\endtrivlist}
\newenvironment{theorem}{\proclaim{Theorem}}{\endproclaim}
\newenvironment{proposition}{\proclaim{Proposition}}{\endproclaim}
\newenvironment{corollary}{\proclaim{Corollary}}{\endproclaim}
\newenvironment{lemma}{\proclaim{Lemma}}{\endproclaim}
\newenvironment{definition}{\explain{Definition.}}{\endexplain}
\newenvironment{remark}{\explain{Remark.}}{\endexplain}
\newenvironment{example}{\explain{Example.}}{\endexplain}
%
\newenvironment{figure}[1][\relax]{\vspace*{1ex}\begin{center}}{\end{center}}
\def\caption#1{\vspace*{-4ex}\begin{quotation}\magenta #1 \end{quotation}}
\newcommand{\standardfigure}[2]{%
  \begin{figure} \includegraphics[width=\textwidth]{#1} \caption{#2} \end{figure}
}
%
\def\label#1{\relax}
\def\ref#1{\relax}
%
\endinput
